<?php
// get_admins.php
session_start();

// Check if user is logged in and is root admin
if (!isset($_SESSION['admin_id']) || $_SESSION['admin_role'] !== 'root') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit;
}

// Include database connection
require_once 'php/db.php';

header('Content-Type: application/json');

try {
    // Get all admins
    $stmt = $pdo->prepare("SELECT id, name, email, role, created_at, last_login FROM admin ORDER BY role DESC, created_at DESC");
    $stmt->execute();
    $admins = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'admins' => $admins]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Failed to load admins: ' . $e->getMessage()]);
}
?>