<?php
// ajax/get_linked_accounts.php
session_start();
require_once 'php/db.php';

if (!isset($_SESSION['admin_id']) || $_SESSION['admin_role'] !== 'root') {
    echo json_encode(['success' => false, 'message' => 'Unauthorized']);
    exit;
}

if (!isset($_GET['primary_id'])) {
    echo json_encode(['success' => false, 'message' => 'Primary ID required']);
    exit;
}

$primary_id = $_GET['primary_id'];

try {
    // Get primary account info
    $stmt = $pdo->prepare("
        SELECT p.*, u.first_name, u.last_name 
        FROM primary_account p 
        INNER JOIN users u ON p.user_id = u.user_id 
        WHERE p.id = ?
    ");
    $stmt->execute([$primary_id]);
    $primary = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$primary) {
        echo json_encode(['success' => false, 'message' => 'Primary account not found']);
        exit;
    }
    
    // Get linked accounts
    $stmt = $pdo->prepare("
        SELECT l.*, 
               u.username, 
               u.first_name, 
               u.last_name, 
               u.email,
               u.profile_url
        FROM link_accounts l
        INNER JOIN users u ON l.user_id = u.user_id
        WHERE l.primary_id = ?
        ORDER BY l.created_at DESC
    ");
    $stmt->execute([$primary_id]);
    $accounts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'primary_name' => $primary['first_name'] . ' ' . $primary['last_name'],
        'accounts' => $accounts
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Error: ' . $e->getMessage()]);
}