<?php
// get_testimony.php
session_start();

// Check if user is logged in
if (!isset($_SESSION['admin_id'])) {
    echo json_encode(['success' => false, 'message' => 'Not authenticated']);
    exit;
}


// Include database connection
require_once 'php/db.php';

header('Content-Type: application/json');

try {
    // Get statistics - UPDATED: Count only testimonies with user_status = 'I have testified'
    $statsStmt = $pdo->query("
        SELECT 
            SUM(CASE WHEN status = 'pending' AND user_status = 'I have testified' THEN 1 ELSE 0 END) as pending,
            SUM(CASE WHEN status = 'approved' AND user_status = 'I have testified' THEN 1 ELSE 0 END) as approved,
            SUM(CASE WHEN status = 'rejected' AND user_status = 'I have testified' THEN 1 ELSE 0 END) as rejected,
            SUM(CASE WHEN status = 'waiting' AND user_status = 'I have testified' THEN 1 ELSE 0 END) as waiting,
            SUM(CASE WHEN user_status = 'I have testified' THEN 1 ELSE 0 END) as total
        FROM testimony
    ");
    $stats = $statsStmt->fetch(PDO::FETCH_ASSOC);
    
    // Get pending testimonies with user and order information
    // UPDATED: Added condition for user_status = 'I have testified'
    $stmt = $pdo->prepare("
        SELECT 
            t.*,
            o.amount,
            o.seller_id,
            so.user_id as seller_user_id,
            u.username,
            CONCAT(u.first_name, ' ', u.last_name) as user_name,
            u.profile_url,
            u.country
        FROM testimony t
        JOIN orders o ON t.order_id = o.id
        JOIN seller_orders so ON o.seller_id = so.id
        JOIN users u ON so.user_id = u.user_id
        WHERE t.status = 'pending' 
        AND t.user_status = 'I have testified'
        ORDER BY t.created_at DESC
    ");
    
    $stmt->execute();
    $testimonies = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'stats' => $stats,
        'testimonies' => $testimonies
    ]);
    
} catch (PDOException $e) {
    error_log("Get testimonies error: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'message' => 'Database error'
    ]);
    exit;
}
?>