<?php
session_start();

if (isset($_SESSION['admin_id'])) {
    header('Location: overview.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Secure Admin Panel</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Stretch+Pro&family=Orbitron:wght@400;700;900&family=Inter:wght@300;400;600&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            color: #0f172a;
        }
        
        .admin-container {
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
        }
        
        .secure-badge {
            background: linear-gradient(90deg, #ef4444, #dc2626);
            color: white;
            padding: 10px 25px;
            border-radius: 50px;
            font-size: 14px;
            font-weight: 600;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 30px;
            box-shadow: 0 4px 15px rgba(239, 68, 68, 0.2);
            letter-spacing: 1px;
        }
        
        .admin-header {
            text-align: center;
            margin-bottom: 50px;
        }
        
        .admin-title {
            font-family: 'Stretch Pro', sans-serif;
            font-size: 4.5rem;
            background: linear-gradient(90deg, #22c55e, #3b82f6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            line-height: 1;
            margin-bottom: 10px;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        
        .admin-subtitle {
            font-family: 'Orbitron', monospace;
            font-size: 1.2rem;
            color: #64748b;
            font-weight: 600;
            letter-spacing: 3px;
            text-transform: uppercase;
        }
        
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 50px 40px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(10px);
            position: relative;
            overflow: hidden;
        }
        
        .login-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, #22c55e, #3b82f6);
        }
        
        .input-group {
            margin-bottom: 30px;
            position: relative;
        }
        
        .input-label {
            display: block;
            font-family: 'Orbitron', monospace;
            font-size: 0.9rem;
            color: #475569;
            margin-bottom: 10px;
            font-weight: 600;
            letter-spacing: 1px;
            text-transform: uppercase;
        }
        
        .input-field {
            width: 100%;
            padding: 16px 20px;
            font-size: 1rem;
            background: white;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            color: #0f172a;
            font-family: 'Inter', sans-serif;
            transition: all 0.3s ease;
        }
        
        .input-field:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }
        
        .input-field::placeholder {
            color: #94a3b8;
        }
        
        .input-icon {
            position: absolute;
            right: 20px;
            top: 42px;
            color: #64748b;
            font-size: 1.2rem;
        }
        
        .login-button {
            width: 100%;
            background: linear-gradient(90deg, #22c55e, #3b82f6);
            color: white;
            border: none;
            padding: 18px;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            font-family: 'Orbitron', monospace;
            letter-spacing: 1px;
            text-transform: uppercase;
            margin-top: 20px;
            box-shadow: 0 4px 15px rgba(34, 197, 94, 0.3);
            position: relative;
            overflow: hidden;
        }
        
        .login-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 25px rgba(34, 197, 94, 0.4);
        }
        
        .login-button:active {
            transform: translateY(0);
        }
        
        .login-button::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: 0.5s;
        }
        
        .login-button:hover::after {
            left: 100%;
        }
        
        .security-note {
            text-align: center;
            margin-top: 30px;
            padding: 15px;
            background: #f1f5f9;
            border-radius: 10px;
            border-left: 4px solid #22c55e;
        }
        
        .security-text {
            font-size: 0.9rem;
            color: #475569;
            font-weight: 500;
        }
        
        .security-text i {
            color: #22c55e;
            margin-right: 8px;
        }
        
        .alert-message {
            padding: 12px 20px;
            border-radius: 10px;
            margin-bottom: 20px;
            display: none;
            font-weight: 500;
        }
        
        .alert-error {
            background-color: #fee2e2;
            border: 1px solid #fecaca;
            color: #dc2626;
        }
        
        .alert-success {
            background-color: #dcfce7;
            border: 1px solid #bbf7d0;
            color: #16a34a;
        }
        
        /* Animation for title */
        @keyframes stretchPulse {
            0%, 100% { 
                letter-spacing: 1px;
                text-shadow: 0 0 20px rgba(34, 197, 94, 0.3);
            }
            50% { 
                letter-spacing: 2px;
                text-shadow: 0 0 30px rgba(34, 197, 94, 0.5);
            }
        }
        
        .admin-title {
            animation: stretchPulse 3s ease-in-out infinite;
        }
        
        /* Responsive */
        @media (max-width: 768px) {
            .admin-title {
                font-size: 3.5rem;
            }
            
            .admin-subtitle {
                font-size: 1rem;
                letter-spacing: 2px;
            }
            
            .login-card {
                padding: 40px 30px;
            }
            
            .secure-badge {
                font-size: 13px;
                padding: 8px 20px;
            }
        }
        
        @media (max-width: 480px) {
            .admin-title {
                font-size: 2.8rem;
            }
            
            .admin-subtitle {
                font-size: 0.9rem;
                letter-spacing: 1px;
            }
            
            .login-card {
                padding: 30px 20px;
            }
            
            .secure-badge {
                font-size: 12px;
                padding: 6px 16px;
            }
            
            .input-field {
                padding: 14px 16px;
                font-size: 0.95rem;
            }
            
            .login-button {
                padding: 16px;
                font-size: 1rem;
            }
        }
        
        @media (max-width: 360px) {
            .admin-title {
                font-size: 2.2rem;
            }
            
            .admin-subtitle {
                font-size: 0.8rem;
            }
            
            body {
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="admin-container">
        <div class="secure-badge">
            <i class="fas fa-shield-alt"></i>
            BCA 
        </div>
        
        <div class="admin-header">
            <h1 class="admin-title">sap</h1>
            <div class="admin-subtitle">Secure admin Panel</div>
        </div>
        
        <div class="login-card">
            <div id="alertMessage" class="alert-message"></div>
            
            <div class="input-group">
                <label class="input-label">Email Address</label>
                <input type="email" id="email" class="input-field" placeholder="Enter admin email">
                <div class="input-icon">
                    <i class="fas fa-envelope"></i>
                </div>
            </div>
            
            <div class="input-group">
                <label class="input-label">Passkey</label>
                <input type="password" id="passkey" class="input-field" placeholder="Enter secure passkey">
                <div class="input-icon">
                    <i class="fas fa-key"></i>
                </div>
            </div>
            
            <button class="login-button" id="loginBtn">
                <i class="fas fa-lock"></i> Authenticate Access
            </button>
            
            <div class="security-note">
                <p class="security-text">
                    <i class="fas fa-exclamation-circle"></i>
                    This panel is restricted to authorized personnel only. All access attempts are logged.
                </p>
            </div>
        </div>
    </div>

    <script>
        // Add some interactive effects
        document.querySelectorAll('.input-field').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.querySelector('.input-icon').style.color = '#3b82f6';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.querySelector('.input-icon').style.color = '#64748b';
            });
        });
        
        // Handle form submission
        document.getElementById('loginBtn').addEventListener('click', function(e) {
            e.preventDefault();
            
            const email = document.getElementById('email').value.trim();
            const passkey = document.getElementById('passkey').value.trim();
            const alertMessage = document.getElementById('alertMessage');
            
            // Clear previous alerts
            alertMessage.style.display = 'none';
            alertMessage.className = 'alert-message';
            
            // Validate inputs
            if (!email || !passkey) {
                showAlert('Please fill in all fields', 'error');
                return;
            }
            
            if (!validateEmail(email)) {
                showAlert('Please enter a valid email address', 'error');
                return;
            }
            
            // Disable button and show loading state
            const originalHTML = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Verifying...';
            this.disabled = true;
            
            // Prepare form data
            const formData = new FormData();
            formData.append('email', email);
            formData.append('passkey', passkey);
            
            // Send AJAX request
            fetch('b_login.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showAlert('Login successful! Redirecting...', 'success');
                    // Redirect to overview after 1.5 seconds
                    setTimeout(() => {
                        window.location.href = 'overview.php';
                    }, 1500);
                } else {
                    showAlert(data.message || 'Login failed. Please check your credentials.', 'error');
                    // Reset button after error
                    this.innerHTML = originalHTML;
                    this.disabled = false;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                showAlert('An error occurred. Please try again.', 'error');
                // Reset button after error
                this.innerHTML = originalHTML;
                this.disabled = false;
            });
        });
        
        function showAlert(message, type) {
            const alertMessage = document.getElementById('alertMessage');
            alertMessage.textContent = message;
            alertMessage.className = `alert-message alert-${type}`;
            alertMessage.style.display = 'block';
            
            // Auto-hide success messages
            if (type === 'success') {
                setTimeout(() => {
                    alertMessage.style.display = 'none';
                }, 3000);
            }
        }
        
        function validateEmail(email) {
            const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return re.test(email);
        }
        
        // Allow Enter key to submit form
        document.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                document.getElementById('loginBtn').click();
            }
        });
    </script>
</body>
</html>