<?php
session_start();

// Hardcoded PIN
$correctPin = "568363695433";

// Handle PIN form submission
if (isset($_POST['pin'])) {
    if ($_POST['pin'] === $correctPin) {
        $_SESSION['pin'] = $correctPin;
        header("Location: upload.php"); // refresh page to show upload form
        exit();
    } else {
        $loginError = "❌ Wrong PIN!";
    }
}

// If not logged in yet, show PIN form
if (!isset($_SESSION['pin']) || $_SESSION['pin'] !== $correctPin):
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>PIN Login</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f0f4f8;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            text-align: center;
            width: 300px;
        }
        input[type="password"] {
            padding: 10px;
            width: 80%;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 8px;
        }
        button {
            padding: 10px 20px;
            background: #3498db;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: transform 0.2s;
        }
        button:hover {
            transform: scale(1.05);
            background: #2980b9;
        }
        .error {
            color: red;
            margin-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Enter PIN</h2>
        <form method="post">
            <input type="password" name="pin" placeholder="Enter PIN" required><br>
            <button type="submit">Login</button>
        </form>
        <?php if (!empty($loginError)): ?>
            <p class="error"><?= htmlspecialchars($loginError) ?></p>
        <?php endif; ?>
    </div>
</body>
</html>
<?php
exit;
endif;

// =========================
// Upload logic (only for logged-in users)
// =========================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $uploadDir = __DIR__ . '/'; // same directory as upload.php

    if ($_FILES['file']['error'] === UPLOAD_ERR_OK) {
        $fileName = basename($_FILES['file']['name']);
        $targetFile = $uploadDir . $fileName;

        if (move_uploaded_file($_FILES['file']['tmp_name'], $targetFile)) {
            $message = "✅ File '$fileName' uploaded successfully (overwritten if existed).";
        } else {
            $message = "❌ Failed to upload file.";
        }
    } else {
        $message = "⚠️ No file selected or upload error.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>File Upload</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: #f0f4f8;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 15px;
            box-shadow: 0 4px 15px rgba(0,0,0,0.1);
            text-align: center;
            width: 350px;
        }
        h2 {
            margin-bottom: 20px;
        }
        input[type="file"] {
            margin-bottom: 15px;
        }
        button {
            padding: 10px 20px;
            background: #3498db;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: transform 0.2s;
        }
        button:hover {
            transform: scale(1.05);
            background: #2980b9;
        }
        .message {
            margin-top: 20px;
            font-weight: bold;
        }
        .spinner {
            display: none;
            margin-top: 15px;
            width: 30px;
            height: 30px;
            border: 4px solid #ddd;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-left: auto;
            margin-right: auto;
        }
        @keyframes spin {
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Upload File</h2>
        <form method="post" enctype="multipart/form-data" onsubmit="showSpinner()">
            <input type="file" name="file" required><br>
            <button type="submit">Upload</button>
            <div class="spinner" id="spinner"></div>
        </form>
        <?php if (!empty($message)): ?>
            <p class="message"><?= htmlspecialchars($message) ?></p>
        <?php endif; ?>
    </div>

    <script>
        function showSpinner() {
            document.getElementById("spinner").style.display = "block";
        }
    </script>
</body>
</html>