<?php
// menu.php - Sidebar navigation menu

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in as moderator or root
if (!isset($_SESSION['admin_role']) || ($_SESSION['admin_role'] !== 'moderator' && $_SESSION['admin_role'] !== 'root')) {
    // Redirect to login or show error
    header('Location: index.php');
    exit();
}
?>
<!-- Sidebar Styles -->
<style>
    @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
    
    :root {
        --primary: #3b82f6;
        --primary-dark: #1d4ed8;
        --secondary: #10b981;
        --secondary-dark: #059669;
        --danger: #ef4444;
        --warning: #f59e0b;
        --dark: #1f2937;
        --light: #f9fafb;
        --gray: #6b7280;
        --gray-light: #e5e7eb;
        --success: #10b981;
    }
    
    .admin-container {
        display: flex;
        min-height: 100vh;
    }
    
    /* Sidebar Styles */
    .sidebar {
        width: 260px;
        background: white;
        border-right: 1px solid var(--gray-light);
        padding: 25px 0;
        position: fixed;
        height: 100vh;
        overflow-y: auto;
        box-shadow: 2px 0 10px rgba(0, 0, 0, 0.05);
        transition: all 0.3s ease;
        z-index: 1000;
    }
    
    .sidebar.collapsed {
        width: 80px;
    }
    
    .logo {
        padding: 0 25px 30px 25px;
        border-bottom: 1px solid var(--gray-light);
        margin-bottom: 25px;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .logo {
        padding: 0 20px 20px 20px;
        text-align: center;
    }
    
    .logo h1 {
        font-size: 24px;
        font-weight: 800;
        background: linear-gradient(90deg, var(--primary), var(--secondary));
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        margin-bottom: 5px;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .logo h1 {
        display: none;
    }
    
    .logo p {
        font-size: 12px;
        color: var(--gray);
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .logo p {
        display: none;
    }
    
    .admin-info {
        padding: 0 25px 25px 25px;
        border-bottom: 1px solid var(--gray-light);
        margin-bottom: 25px;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .admin-info {
        padding: 0 20px 20px 20px;
        text-align: center;
    }
    
    .admin-avatar {
        width: 50px;
        height: 50px;
        background: linear-gradient(135deg, var(--primary), var(--secondary));
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-size: 20px;
        font-weight: 600;
        margin-bottom: 15px;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .admin-avatar {
        width: 40px;
        height: 40px;
        font-size: 16px;
        margin: 0 auto 10px auto;
    }
    
    .admin-details h3 {
        font-size: 16px;
        font-weight: 600;
        margin-bottom: 5px;
        color: var(--dark);
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .admin-details h3 {
        display: none;
    }
    
    .admin-details p {
        font-size: 13px;
        color: var(--gray);
        background: var(--gray-light);
        padding: 3px 10px;
        border-radius: 20px;
        display: inline-block;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .admin-details p {
        display: none;
    }
    
    .nav-menu {
        padding: 0 15px;
    }
    
    .nav-item {
        display: flex;
        align-items: center;
        padding: 12px 20px;
        margin-bottom: 8px;
        border-radius: 10px;
        color: var(--gray);
        text-decoration: none;
        transition: all 0.3s ease;
        font-weight: 500;
        white-space: nowrap;
        overflow: hidden;
    }
    
    .sidebar.collapsed .nav-item {
        justify-content: center;
        padding: 12px;
    }
    
    .nav-item:hover {
        background: var(--gray-light);
        color: var(--dark);
    }
    
    .nav-item.active {
        background: linear-gradient(90deg, var(--primary), var(--primary-dark));
        color: white;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    }
    
    .nav-item i {
        width: 24px;
        margin-right: 12px;
        font-size: 18px;
        flex-shrink: 0;
    }
    
    .sidebar.collapsed .nav-item i {
        margin-right: 0;
        font-size: 20px;
    }
    
    .nav-item span {
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed .nav-item span {
        display: none;
    }
    
    .logout-btn {
        margin-top: 30px;
        padding: 12px 20px;
        color: var(--danger);
        display: flex;
        align-items: center;
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
        border-radius: 10px;
        white-space: nowrap;
        overflow: hidden;
    }
    
    .sidebar.collapsed .logout-btn {
        justify-content: center;
        padding: 12px;
    }
    
    .logout-btn:hover {
        background: #fee2e2;
    }
    
    .sidebar.collapsed .logout-btn span {
        display: none;
    }
    
    .toggle-sidebar {
        position: absolute;
        top: 20px;
        right: -15px;
        width: 30px;
        height: 30px;
        background: var(--primary);
        color: white;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        cursor: pointer;
        box-shadow: 0 2px 8px rgba(59, 130, 246, 0.3);
        transition: all 0.3s ease;
        border: 2px solid white;
        z-index: 1001;
    }
    
    .toggle-sidebar:hover {
        background: var(--primary-dark);
        transform: scale(1.1);
    }
    
    .toggle-sidebar i {
        transition: transform 0.3s ease;
    }
    
    .sidebar.collapsed .toggle-sidebar i {
        transform: rotate(180deg);
    }
    
    /* Main Content Styles */
    .main-content {
        flex: 1;
        margin-left: 260px;
        padding: 30px;
        transition: all 0.3s ease;
    }
    
    .sidebar.collapsed ~ .main-content {
        margin-left: 80px;
    }
    
    /* Responsive */
    @media (max-width: 1200px) {
        .sidebar:not(.collapsed) {
            width: 80px;
            padding: 20px 0;
        }
        
        .sidebar:not(.collapsed) .logo h1,
        .sidebar:not(.collapsed) .logo p,
        .sidebar:not(.collapsed) .admin-details h3,
        .sidebar:not(.collapsed) .admin-details p,
        .sidebar:not(.collapsed) .nav-item span {
            display: none;
        }
        
        .sidebar:not(.collapsed) .admin-info,
        .sidebar:not(.collapsed) .logo {
            padding: 0 20px 20px 20px;
            text-align: center;
        }
        
        .sidebar:not(.collapsed) .admin-avatar {
            width: 40px;
            height: 40px;
            font-size: 16px;
            margin: 0 auto 10px auto;
        }
        
        .sidebar:not(.collapsed) .nav-item {
            justify-content: center;
            padding: 12px;
        }
        
        .sidebar:not(.collapsed) .nav-item i {
            margin-right: 0;
            font-size: 20px;
        }
        
        .sidebar:not(.collapsed) ~ .main-content {
            margin-left: 80px;
        }
    }
    
    @media (max-width: 768px) {
        .main-content {
            padding: 20px;
        }
        
        .header {
            flex-direction: column;
            gap: 15px;
            align-items: flex-start;
        }
        
        .timer-container {
            flex-direction: column;
            text-align: center;
            gap: 20px;
        }
        
        .timer {
            min-width: auto;
            font-size: 36px;
        }
        
        .stats-grid {
            grid-template-columns: 1fr;
        }
    }
    
    @media (max-width: 480px) {
        .timer {
            font-size: 28px;
            padding: 10px 15px;
        }
        
        .stat-card {
            padding: 20px;
        }
        
        .stat-value {
            font-size: 28px;
        }
        
        .auction-section, .activities-section {
            padding: 20px;
        }
    }
</style>

<!-- Sidebar HTML -->
<div class="sidebar" id="sidebar">
    <div class="toggle-sidebar" id="toggleSidebar">
        <i class="fas fa-chevron-left"></i>
    </div>
    
    <div class="logo">
        <h1>BCA</h1>
        <p>Secure Admin Panel</p>
    </div>
    
    <div class="admin-info">
        <div class="admin-avatar">
            <?php 
            $initial = isset($_SESSION['admin_name']) ? strtoupper(substr($_SESSION['admin_name'], 0, 1)) : 'A';
            echo $initial;
            ?>
        </div>
        <div class="admin-details">
            <h3><?php echo htmlspecialchars($_SESSION['admin_name'] ?? 'Admin'); ?></h3>
            <p><?php echo htmlspecialchars(ucfirst($_SESSION['admin_role'] ?? 'root')); ?></p>
        </div>
    </div>
    
    <div class="nav-menu">
        <?php if ($_SESSION['admin_role'] === 'root'): ?>
            <!-- Full menu for root admin -->
            <a href="overview.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'overview.php' ? 'active' : ''; ?>">
                <i class="fas fa-chart-line"></i>
                <span>Overview</span>
            </a>
            <a href="auction.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'auction.php' ? 'active' : ''; ?>">
                <i class="fas fa-gavel"></i>
                <span>Auction</span>
            </a>
            <a href="users.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'users.php' ? 'active' : ''; ?>">
                <i class="fas fa-users"></i>
                <span>Users</span>
            </a>
            <a href="orders.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'orders.php' ? 'active' : ''; ?>">
                <i class="fas fa-shopping-cart"></i>
                <span>Orders</span>
            </a>
            <a href="testimonies.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'testimonies.php' ? 'active' : ''; ?>">
                <i class="fas fa-comment"></i>
                <span>Testimonies</span>
            </a>
            <a href="annoucement.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'annoucement.php' ? 'active' : ''; ?>">
                <i class="fas fa-info"></i>
                <span>Annoucement</span>
            </a>
            <a href="bonus.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'bonus.php' ? 'active' : ''; ?>">
                <i class="fas fa-gift"></i>
                <span>Bonus System</span>
            </a>
            <a href="stream.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'stream.php' ? 'active' : ''; ?>">
                <i class="fas fa-video"></i>
                <span>Conference Meetings</span>
            </a>
                <a href="order.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'order.php' ? 'active' : ''; ?>">
                <i class="fas fa-video"></i>
                <span>list order</span>
            </a>
            <a href="admin.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'admin.php' ? 'active' : ''; ?>">
                <i class="fas fa-user-shield"></i>
                <span>Admin and Privilege</span>
            </a>
              <a href="kyc.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'kyc.php' ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i>
                <span>KCY</span>
            </a>
            <a href="settings.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'settings.php' ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i>
                <span>Settings</span>
            </a>
           
        <?php else: ?>
            <!-- Limited menu for non-root admins (moderators) -->
            <a href="auction.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'auction.php' ? 'active' : ''; ?>">
                <i class="fas fa-gavel"></i>
                <span>Auction</span>
            </a>
            <a href="annoucement.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'annoucement.php' ? 'active' : ''; ?>">
                <i class="fas fa-info"></i>
                <span>Annoucement</span>
            </a>
            <a href="testimonies.php" class="nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'testimonies.php' ? 'active' : ''; ?>">
                <i class="fas fa-comment"></i>
                <span>Testimonies</span>
            </a>
        <?php endif; ?>
        
        <a href="logout.php" class="logout-btn">
            <i class="fas fa-sign-out-alt"></i>
            <span>Logout</span>
        </a>
    </div>
</div>

<script>
    // Toggle sidebar
    document.getElementById('toggleSidebar').addEventListener('click', function() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('collapsed');
        
        // Update icon
        const icon = this.querySelector('i');
        if (sidebar.classList.contains('collapsed')) {
            icon.className = 'fas fa-chevron-right';
        } else {
            icon.className = 'fas fa-chevron-left';
        }
        
        // Save state in localStorage
        localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
    });
    
    // Load sidebar state from localStorage
    document.addEventListener('DOMContentLoaded', function() {
        const sidebar = document.getElementById('sidebar');
        const isCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
        
        if (isCollapsed) {
            sidebar.classList.add('collapsed');
            const icon = document.querySelector('#toggleSidebar i');
            icon.className = 'fas fa-chevron-right';
        }
    });
</script>